﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class DisablePagingExecutive : UserControl, ICorrespondenceOS, IControl
    {
        private DisablePagingExecutiveController DisablePagingExecutiveController;

        public DisablePagingExecutive()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsVista_SP3,
#if DEBUG
                                           OS.WindowsSeven,
                                           OS.WindowsSeven_SP1,
                                           OS.WindowsSeven_SP2
#endif
                                       };
        }

        public void SetDisablePagingExecutiveState(bool b)
        {
            checkBox1.Checked = b;
        }

        public bool GetDisablePagingExecutiveState()
        {
            return checkBox1.Checked;
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:disablepagingexecutive"));
                userHelp.Show();
            }
        }

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IControl メンバ

        public void Apply()
        {
            DisablePagingExecutiveController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return DisablePagingExecutiveController.BackUp();
        }

        #endregion

        private void DisablePagingExecutive_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            DisablePagingExecutiveController = new DisablePagingExecutiveController(this,
                                                                                    (IDisablePagingExecutiveStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new DisablePagingExecutiveDefaultStrategy
                                                                                                     ()
                                                                                             }));
            DisablePagingExecutiveController.Read();
        }
    }
}